' <><><><><><><><><><><><><><><><><><><><><><><><><><><><><><><><><><><><><><><>
'
' Gertesoftware ... : Multifunktionsrelais MFR
' - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
' Programm ......... : Relaisansteuerung mit dem Mikrocontroller (MC) AT90S2313
'  Prog.-Sprache ... : BASCOM
'  Prog.-Inhalt .... : - Konfiguration eines Multifunktionsrelais
'                      - Einstellungen in dieser Programmkonfiguration
'                        > Boolesche Funktion ... : AND
'                        > Betriebsart .......... : keine Verzgerung
'
' Programmierer .... : Ingolf Bauer (ingolf.bauer@nexgo.de)
'  Prog.-Version ... : 0.9
'  Prog.-Datum ..... : 01.07.2005
'
' <><><><><><><><><><><><><><><><><><><><><><><><><><><><><><><><><><><><><><><>

'Historie
'========
'V 0.9 (nderungen zur Version 0.1):
'- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
'00. 20.03.2005 - Programmspeicher des MCs (Flashspeicher): ca. 90% belegt
'                 (abhngig von der verwendeten Boolschen Funktion)
'01. 20.03.2005 - Erstellung des Quellcodes
'02. 25.05.2005 - Bearbeitung der Hinweise und Kommentare

'V 0.1
'- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
'01. 01.02.2005 - Konzepterarbeitung und grundlegende Testkonfigurationen
'-------------------------------------------------------------------------------

'Hinweise
'========
' Inhaltsverzeichnis
' ------------------
' 00.  Allgemeines
'  00.1 Funktion
'  00.2 Dokumentation
'
' 01.  Einstellungen
'  01.1 Funktion
'  01.2 Compiler
'  01.3 Entprellzeit
'
' 02.  Zeitberechnung
'  02.1 Systemtakt
'
' 03.  Mikrocontroller AT90S2313
'  03.0 Abkrzungen
'  03.1 Anschluschema
'  03.2 Programmierung
'
' 04.  I/O-Ports
'  04.1 Belegung der AVR-Anschlsse
'
' 05.  Funktionen des Multifunktionsrelais
'  05.1 Bedeutung der Symbole
'  05.2 bersicht der Funktionen
'  05.3 bersicht der Betriebsarten
'  05.4 Initialisierung der Funktion
'  05.5 Initialisierung der Betriebsart
'  05.6 Verzgerungs- bzw. Taktzeiten
'- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -

'00.  Allgemeines
'00.1 Funktion
'     Beim MFR handelt es sich um eine mikrocontrolleruntersttzte Ansteuerung
'     eines Relais.
'     Eine eventuelle Erweiterung auf mehrere Steuereingnge, Relais oder,
'     fr ein schnelleres Schalten auch Power-MOSFET, Triacs o. ., wird nur
'     durch die Anzahl der zur Verfgung stehenden digitalen Ein- bzw. Ausgangs-
'     kanle begrenzt.
'     Die Anzahl kann noch erweitert werden, wenn ein anderer MC aus der ATMEL-
'     Familie eingesetzt wird. Die Programmzeile
'        $regfile = "2313def.dat"               'Mikrocontroller : AT90S2313
'     mu dann entsprechend angepat werden.

'00.2 Dokumentation
'     Sollte kein Schaltplan fr den Aufbau der Relaissteuerung dieser Dokumen-
'     tation beiliegen oder wird Hilfe zum Programmcode bentigt, bekommt man
'     unter der oben genannten Emailadresse die entsprechende Untersttzung.
'     Gleiches gilt fr diejenigen, die das Programmiermodul PRM, auf das etwas
'     spter eingegangen wird, aufbauen und fr die Programmierung des MCs ein-
'     setzen mchten.
'
'     Zum Quellcode ist anzumerken, da er eine umfangreiche Palette der mg-
'     lichen Einstellungen abdeckt. Bentigt man dies nicht, kann an vielen
'     Stellen der Programmcode vereinfacht werden, um fr individuelle Lsun-
'     gen Platz im Programmspeicher des MCs zu gewinnen, so zum Beispiel zur Re-
'     alisierung einer Uhrenfunktion.
'
'     Anregungen, Meinungen und Korrekturvorschlge sind fr weitere Entwicklun-
'     gen sehr hilfreich und stets willkommen.

'01.  Einstellungen
'01.1 Funktion
'     Mit dem hier vorgestellten Quellcode ist man in der Lage, eine groe An-
'     zahl individueller Anforderungen an die Funktionalitt eines Relais zu
'     realisieren. Dazu sollte zunchst die Funktion des Relais genau definiert
'     werden:
'     - Verwendung einer Booleschen Logik fr die zwei Steuereingnge
'     - Festlegung der Entprellzeit
'     - Festlegung von Verzgerungszeiten beim Anzug bzw. Abfall des Relais
'     - Festlegung der Schalt- bzw. Pausenzeiten bei der Betriebsart Taktgeber
'
'     Nachdem diese Festlegungen getroffen wurden oder man sich sein eigenes
'     Programm geschrieben hat, kann mit der Demoversion von BASCOM dieses
'     compiliert werden. Fr eine Relaisansteuerung sollte die Beschrnkung auf
'     2 K Programmcode keine Einschrnkungen bedeuten.
'
'     Nach dem Programmieren des MCs besitzt man einen Relaisbaustein, der in
'     den verschiedensten Anwendungen zum Einsatz kommen kann.
'     Da nicht alle Kanle der Ports belegt sind, knnen diese fr weitere Funk-
'     tionen verwendet werden.

'01.2 Compiler
'     Im Men von BASCOM (Options-Compiler-Chip) vor dem Compilieren mindestens
'     einstellen mit:
'     HW Stack: 48     Soft Stack:  8     Framesize: 32

'01.3 Entprellzeit
'     Dieser Wert kann von 0-255 ms (Datentyp: Byte) festgelegt werden.
'     Zu beachten ist, da diese Zeit in eine programmierte Verzgerungszeit
'     einbezogen werden mu.

'02.  Zeitberechnung
'02.1 Systemtakt
'     Formeln zur Berechnung des Systemtaktes von 1 ms
'
'     ST = TF * TA / QF   bzw.  TA = ST * QF / TF
'
'     ST: Systemtakt              TF: Prescale (Teiler Timer 1)   TA: Taktanzahl
'     QF: Quarzfrequenz           T: Timer-berlauf (65.536)
'
'     Beispiel:
'     =========
'     geg.: ST (Systemtakt)     ges.: TA     (Taktanzahl)
'           QF = 4,0 MHz              Timer1 (Wert fr Voreinstellung)
'           TF = 8
'
'     Formel ..... : TA = ST * QF / TF
'                    TA = 0,001 s * 4 MHz / 8
'     Ergebnis ... : TA = 500
'
'     Erforderlicher Voreinstellwert fr den Timer 1
'     ----------------------------------------------
'     Timer ...... : Timer1 = T - TA
'                    Timer1 = 65.536 - TA
'                    Timer1 = 65.036

'03.  Mikrocontroller AT90S2313
'03.0 Abkrzungen
'     DAx.y .............. : digitaler Ausgang (Port.Kanal)
'     DEx.y .............. : digitaler Eingang (Port.Kanal)
'     EP ................. : Erweiterungsport
'     GND ................ : Masse der Versorgungsspannung
'     LED-gn ............. : Ansteuerung LED (grn)
'     LED-rt ............. : Ansteuerung LED (rot)
'     PRG ................ : Programmierinterface (parallele Schnittstelle)
'     P5V ................ : Versorgungsspannung P5V (stabilisiert)
'     PRG ................ : Programmierung ber LPT-Schnittstelle eines PCs
'     QUA ................ : Quarzanschlu
'     SEx ................ : Steuereingang (1-2)
'     TEST ............... : Eingang Test
'     TRA ................ : Ansteuerung des Schalttransisitors

'03.1 Anschluschema
'     - Port B
'       ber Port B kann der MC innerhalb der Schaltung programmiert werden.
'       Alle nicht belegten Kanle knnen bei Bedarf individuell verwendet
'       werden.
'     - Port D
'       Die Kanle sind als digitale Eingnge bzw. Ausgnge initialisiert.
'       Der Kanal PD7 ist bei diesem MC nicht vorhanden.
'
'                     --------------|_|--------------
'           PRG   --> | 1 [/Reset]          [VCC] 20| === P5V
'           DE1.0 --> | 2 [PD0]        [SCK, PB7] 19| <-- PRG
'           EP ...... | 3 [PD1]       [MISO, PB6] 18| >-- PRG
'           QUA   +++ | 4 [XTAL2]     [MOSI, PB5] 17| <-- PRG
'           QUA   +++ | 5 [XTAL1]           [PB4] 16| ... EP
'           DE1.2 --> | 6 [PD2, INT0]       [PB3] 15| ... EP
'           DE1.3 --> | 7 [PD3, INT1]       [PB2] 14| ... EP
'           DA1.4 --< | 8 [PD4]             [PB1] 13| ... EP
'           DA1.5 --< | 9 [PD5]             [PB0] 12| ... EP
'           GND   === |10 [GND]             [PD6] 11| >-- DA1.6
'                     -------------------------------

'03.2 Programmierung
'     Der MC des MFR kann auf die verschiedensten Arten programmiert werden.
'     Im Internet findet man viele Lsungen, ob per USB, seriell oder parallel.
'     Anschlumig ist der Baustein MKF fr die Programmierung mit dem Pro-
'     grammiermodul PRM optimiert, welches mit einem Trigger (HCT244) aufgebaut
'     ist und ber die parallelel Schnittstelle mit einem PC verbunden wird.
'     Mit der Freeware WinAVR (nicht zu verwechseln mit der gleichnamigen Ent-
'     wicklungssoftware) kann dann der MC beschrieben werden.
'     Bei dem MC AT90S2313 handelt es sich um einen etwas lteren Typ, bei dem
'     die FUSE-Bits bei der Programmierung fr den Einsatz im MFR nicht beachtet
'     werden brauchen.

'04.  I/O-Ports
'04.1 Belegung der AVR-Anschlsse
'     - Port B                            - Port D
'          | AVR || Steuerung                  | AVR || Steuerung
'     ---------------------------         ---------------------------
'     Port | Pin || Typ | Signal          Port | Pin || Typ | Signal
'     ---------------------------         ---------------------------
'     PB0  | 12  ||     | EP              PD0  |  2  || DE  | TEST
'     PB1  | 13  ||     | EP              PD1  |  3  || DE  | EP      *)
'     PB2  | 14  ||     | EP              PD2  |  6  || DE  | SE1
'     PB3  | 15  ||     | EP              PD3  |  7  || DE  | SE2
'     PB4  | 16  ||     | EP              PD4  |  8  || DA  | LED-gn
'     PB5  | 17  || DE  | MOSI            PD5  |  9  || DA  | LED-rt
'     PB6  | 18  || DA  | MISO            PD6  | 11  || DA  | TRA
'     PB7  | 19  || DE  | SCK             -    | -   || -   | -

'     - Sonstige
'          | Pin || Typ | Signal
'     ---------------------------
'          |  1  || DE  | /RESET
'
'     *) Ist mit der Portinitialisierung als digitaler Eingang (DE) festgelegt,
'        kann aber auch als digitaler Ausgang (DA) initialisiert werden, da fr
'        den normalen Einsatz dieser Kanal keine Funktion hat.

'05.  Funktionen des Multifunktionsrelais
'05.1 Bedeutung der Symbole
'     0   : Signalpegel am Steuereingang ist 1 (=> Eingang des MCs: Masse) **)
'     1   : Signalpegel am Steuereingang ist 0 (=> Eingang des MCs: P5V)   **)
'     SEx : Steuereingang (1-2)
'     FKTx: Funktion (1-6)
'     TR  : Transistor (Ausgang) ist 1: Masse (=> Relais schaltet)         **)

'     **) Die Negation der Signale erfolgt bei den Eingangssignalen durch die
'         Optokoppler, beim Ausgangssignal fr die Ansteuerung des Relais durch
'         den Transistor.

'05.2 bersicht der Funktionen
'     Nr   | Bezeichnung        | Logiktabelle | Erluterung der Boolschen Logik
'          |                    | SE1 SE2  TR  |
'     --------------------------------------------------------------------------
'     FKT1 | Konjunktion -  AND |  0   0    0  | wenn SE1= 1 und SE2= 1 ist
'                               |  0   1    0  |  das Relais geschaltet
'                               |  1   0    0  |
'                               |  1   1    1  |
'
'     FKT2 | Sheffer-FKT - NAND |  0   0    1  | wenn SE1= 1 und SE2= 1 ist
'                               |  0   1    1  |  das Relais nicht geschaltet
'                               |  1   0    1  |             =====
'                               |  1   1    0  |
'     - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
'     FKT3 | Disjunktion -   OR |  0   0    0  | wenn SE1= 1 oder SE2= 1 ist
'                               |  0   1    1  |  das Relais geschaltet
'                               |  1   0    1  |
'                               |  1   1    1  |
'
'     FKT4 | Peirce-FKT  -  NOR |  0   0    1  | wenn SE1= 1 oder SE2= 1 ist
'                               |  0   1    0  |  das Relais nicht geschaltet
'                               |  1   0    0  |             =====
'                               |  1   1    0  |
'     - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
'     FKT5 | Antivalenz  -  XOR |  0   0    0  | wenn SE1= 0 und SE2= 1
'                               |  0   1    1  |  oder
'                               |  1   0    1  | wenn SE1= 1 und SE2= 0 ist
'                               |  1   1    0  |  das Relais geschaltet
'
'     FKT6 | quivalenz  - XNOR |  0   0    1  | wenn SE1= 0 und SE2= 1
'                               |  0   1    0  |  oder
'                               |  1   0    0  | wenn SE1= 1 und SE2= 0 ist
'                               |  1   1    1  |  das Relais nicht geschaltet
'                                                            =====
'     - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
'     FKT7 | Inhibition         |  0   0    0  | wenn SE1= 0 und SE2= 1 ist
'                               |  0   1    1  |  das Relais geschaltet
'                               |  1   0    0  |
'                               |  1   1    0  |
'
'     FKT8 | Implikation        |  0   0    1  | wenn SE1= 0 und SE2= 1 ist
'                               |  0   1    0  |  das Relais nicht geschaltet
'                               |  1   0    1  |             =====
'                               |  1   1    1  |

'05.3 bersicht der Betriebsarten
'     M_ba | Verzgerung | Bezeichnung
'          | Ein   Aus   |
'     --------------------------------------------------------------------------
'        0 |  0     0    | Schalten laut eingestellter Boolescher Funktion
'     - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
'        1 |  0     0    | Schalten im Flip-Flop Betrieb
'     - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
'        2 |  x     y    | Schalten laut initialisierter Boolescher Funktion
'          |             |  Kein Schalten, wenn in der Zeit der Verzgerung die
'          |             |  Bedingung fr das Einschalten nicht mehr erfllt
'          |             |  wird.
'          |             |  Wert x: Zeitdauer der Einschaltverzgerung
'          |             |  Wert y: Zeitdauer der Ausschaltverzgerung
'     - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
'        3 |  x     Y    | Taktgeber (Einschalten laut Boolescher Funktion)
'          |             |  Wert x: Zeitdauer Ein
'          |             |  Wert y: Zeitdauer Aus
'
'     Die Zeitfaktoren (ZF) x und y werden in der Zeile "Zeitfaktoren (ZF) fr
'     die Verzgerungszeit" initialisiert.
'     Das Flag "Zeitbasis" (F_zb) entscheidet, ob der Zeittakt 100 ms oder 1 s
'     betrgt.

'05.4 Initialisierung der Funktion
'     Die Initialisierung der Funktion des MFR (Tabelle laut Punkt 05.2) mu
'     an drei Zeilen im Programm vorgenommen werden. Die entsprechenden Bereiche
'     sind mit dem Zeichen "%" eingeschlossen.
'     Die Zeilen sind mit '[xx Funktionsbedingung] kommentiert, wobei xx fr die
'     Punkte 01-03 stehen.
'     An allen drei Stellen im Quellcode (Auswahl ber Select Case) mssen die
'     Einstellungen aktiv geschaltet werden, die der gewschten Logik entspre-
'     chen. Dabei ist zu beachten, da einige Funktionen nur eine Bedingung, bei
'     anderen zwei Bedingungen erfllt sein mssen. Leider lt der Compiler von
'     BASCOM keine andere Programmierung zu (z. B. Case 1, 3).

'05.5 Initialisierung der Betriebsart
'     Die Initialisierung der Betriebsart des MFR (Tabelle laut Punkt 05.3) mu
'     an einer Zeile im Programm vorgenommen werden.
'     Im Bereich "Initialisierung" kann die jeweilige Option aktiv geschaltet
'     werden.

'05.6 Verzgerungs- bzw. Taktzeiten
'     Die Einstellung kann in Schritten von 100 ms bzw. 1 s erfolgen.
'     Der maximale Wert ist durch die Deklaration der Variablen (Word) auf
'     65.535 s (ca. 18 h) begrenzt, wenn das Flag fr die Zeitbasis auf 1 ge-
'     setzt ist. Die Zeitbasis betrgt dann 1 s.
'     Ist das Flag auf 0 gesetzt, betrgt die Zeitbasis 100 ms. Der maximale
'     Wert ist dann auf den gleichen Wert begrenzt, die maximale Zeit betrgt
'     dann aber nur ca. 1,8 h.
'     Zu beachten ist, da in der Betriebsart "Taktgeber" in diesem Programm
'     die Summe aus Ein- und Ausschaltwert den Wert von 65.535 nicht berschrei-
'     ten darf.

'+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
'+++++                     P R O G R A M M S T A R T                       +++++
'+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++

'Definition
   $regfile = "2313def.dat"                      'Mikrocontroller : AT90S2313
   $crystal = 4000000                            'Quarz ......... : 4,0 MHz

'
'         E I N S T E L L U N G   F  R   D E N   T E S T B E T R I E B
'- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
'Achtung:
'========
' Soll der Compiler fr den Simulationsbetrieb Wartezeiten bergehen, kann im
' Testbetrieb der folgende Befehl ($sim) aktiviert werden.
' $sim
'

'Deklaration
'=Bezug auf die Kanle von Port D
'-Eingnge
   E_test Alias Pind.0                           'Eingang: Test (Prftaste)
   E1 Alias Pind.2                               'Eingang: 1 (Steuereingang 1)
   E2 Alias Pind.3                               'Eingang: 2 (Steuereingang 2)
'-Ausgnge
   A_led_gn Alias Portd.4                        'Ausgang: LED grn
   A_led_rt Alias Portd.5                        'Ausgang: LED rot
   A_transistor Alias Portd.6                    'Ausgang: Schalttransistor

'=Variable
'-Flag
   Dim F_ein As Bit                              'Flag: Status einschalten
   Dim F_aus As Bit                              'Flag: Status ausschalten
   Dim F_pt As Bit                               'Flag: Prftaste
   Dim F_e12 As Bit                              'Flag: Logik Eingnge
   Dim F_m_aes As Bit                            'Flag: Logik Speicher
   Dim F_zb As Bit                               'Flag: Zeitbasis (ZB)
'                                                        0: ZB=  100 ms
'                                                        1: ZB= 1000 ms
'-Merker
   Dim M_fkt As Byte                             'Merker: Funktion
   Dim M_ae As Byte                              'Merker: Abfrage Eingnge
'                                                         .0: Eingang Testtaste
'                                                         .1: Eingang E1
'                                                         .2: Eingang E2
   Dim M_aes As Byte                             'Merker: Bedienung (Speicher)
   Dim M_sa As Byte                              'Merker: Steuerung der Ausgnge
'                                                         .0: Ausgang Transistor
'                                                         .1: Ausgang LED gn
'                                                         .2: Ausgang LED rt
   Dim M_ba As Byte                              'Merker: Betriebsart
   Dim M_epr As Byte                             'Merker: Entprellzeit
   Dim M_ein As Word                             'Merker: Anzugsverzgerung
   Dim M_aus As Word                             'Merker: Abfallverzgerung
'-Takt
   Dim Ta_ve As Word                             'Wert fr Timer1-Voreinstellung
   Dim Ta_001ms As Byte                          'Takt   1 [ms]
   Dim Ta_010ms As Byte                          'Takt  10 [ms]
   Dim Ta_100ms As Byte                          'Takt 100 [ms]
'-Zeit
   Dim T_blk As Byte                             'Blinkzeit     [ms] (Prftaste)
   Dim T_epr As Byte                             'Entprellzeit  [ms]
   Dim T_ein As Word                             'Einschaltzeit [ s]
   Dim T_aus As Word                             'Ausschaltzeit [ s]

'Initialisierung
'=I/O-Ports
'==Port B (ist bei Verwendung des Erweiterungsports zu initialisieren)
'-Steuerung und Programmierschnittstelle
'--Datenrichtung (Ein [0]: Eingang, Aus [1]: Ausgang)
'   Ddrb = &B1111_1111                            'PB0-7 Aus
'--Pullup-Widerstand (aktiv [1], passiv [0])
'---wird bentigt, wenn Initialisierung als Eingangskanal
'   Portb = &B0000_0000                           'PB0-7 passiv

'==Port D
'-Steuerung und Programmierschnittstelle
'--Datenrichtung (Ein [0]: Eingang, Aus [1]: Ausgang)
   Ddrd = &B1111_0000                            'PD0-3 Ein, PD4-7 Aus
'--Pullup-Widerstand (aktiv [1], passiv [0])
'---wird bentigt, wenn Initialisierung als Eingangskanal
   Portd = &B0000_1111                           'PD0-3 aktiv, PD4-7 passiv

'=Timer 1
   Config Timer1 = Timer , Prescale = 8          'Konfiguration Timer1 (T1)
   On Timer1 Int_t1                              'Interrupt  : T1-berlauf
   Enable Timer1                                 'Einschalten: Interrupt T1
   Enable Interrupts                             'Interrupt  : Freigabe global

'Initialisierung
'-Einstellungen
'--Betriebsart
'  (mit einer der mglichen Wertzuweisungen (0-3) wird die Betriebsart festge-
'  legt)
   M_ba = 0                                      'Boolesche Funktion
'   M_ba = 1                                      'Flip-Flop
'   M_ba = 2                                      'Verzgerung
'   M_ba = 3                                      'Taktgeber

'--Entprellzeit [ms]
'  Der maximale Wert ist durch die Deklaration der Variablen (Byte) auf 255 ms
'  begrenzt.
   M_epr = 10                                    'Warten zum Entprellen: 10 ms

'--Voreinstellwert fr
'--- Timer1
'    (mit anderen Werten fr Ta_ve, der Timer-Vorteilung oder der Quarzfrequenz
'    kann der Systemtakt verndert werden)
   Ta_ve = 65036                                 'Systemtakt 1 ms
'--- Speicher
'    (erforderliche Startbedingung)
   M_aes = &B0000_0111                           'Vergleichswert (Eingnge 0-2)

' Zeitbasis (ZB)
' (abhngig vom eingestellten Systemtakt und entscheidend fr die Zeitwerte)
   F_zb = 1                                      '0: 100 ms   1: 1000 ms

' Zeitfaktoren (ZF) fr die Verzgerungszeiten
' (Beispiel: Verzgerung beim Einschalten 1 s, beim Ausschalten 3 s)
   M_ein = 1                                     'Einschalten: ZF 1
   M_aus = 3                                     'Ausschalten: ZF 3

'Programm (Beginn der Schleife)
Do
M_start:
'Prfen, ob Eingangszustand unverndert und stabil ist
'-Eingnge abfragen
   M_ae.0 = E_test : M_ae.1 = E1 : M_ae.2 = E2   'Abfrage: Eingangsport
   If M_ae <> M_aes Then                         'Taste wurde bettigt!
      Gosub Up_epr                               'Entprellen
      If M_ae <> M_aes Then                      'Tastenbettigung stabil?
         M_aes = M_ae                            'Zustand speichern
      End If
   End If

'%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
'Logikbedingung initialisieren
'-Definition der Speicherbelegung
' 0000_00xx
'        ||___ E1 bzw. M_aes.1
'        |____ E2 bzw. M_aes.2

' Eingnge
   F_e12 = 1 : F_m_aes = 1                       'Bedingung nicht erfllt

   M_fkt.0 = E1 : M_fkt.1 = E2                   'Auswertung: Eingnge
   Select Case M_fkt
'-[01 Funktionsbedingung]
'--Funktion bentigt eine "Case"-Anweisung
      Case 0                                     '[FKT1-AND]
'      Case 1 To 3                                '[FKT2-NAND]
'      Case 0 To 2                                '[FKT3-OR]
'      Case 3                                     '[FKT4-NOR]
'      Case 1 To 2                                '[FKT5-XOR]
'      Case 2                                     '[FKT7-Inhibition]
         F_e12 = 0
'- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
'--Funktion bentigt zwei "Case"-Anweisungen
'      Case 0                                     '[FKT6-XNOR]
'      Case 0 To 1                                '[FKT8-Implikation]
'         F_e12 = 0
'      Case 3                                     '[FKT6-XNOR]
'      Case 3                                     '[FKT8-Implikation]
'         F_e12 = 0
   End Select

   M_fkt.0 = M_aes.1 : M_fkt.1 = M_aes.2         'Auswertung: Zustandsspeicher
   Select Case M_fkt
'-[02 Funktionsbedingung]
'--Funktion bentigt eine "Case"-Anweisung
      Case 0                                     '[FKT1-AND]
'      Case 1 To 3                                '[FKT2-NAND]
'      Case 0 To 2                                '[FKT3-OR]
'      Case 3                                     '[FKT4-NOR]
'      Case 1 To 2                                '[FKT5-XOR]
'      Case 2                                     '[FKT7-Inhibition]
         F_m_aes = 0
'- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
'--Funktion bentigt zwei "Case"-Anweisungen
'      Case 0                                     '[FKT6-XNOR]
'      Case 0 To 1                                '[FKT8-Implikation]
'         F_m_aes = 0
'      Case 3                                     '[FKT6-XNOR]
'      Case 3                                     '[FKT8-Implikation]
'         F_m_aes = 0
   End Select
'%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

'Auswertung der Eingnge
'-Prftaste
   If M_aes.0 = 0 Then                           'Prftaste bettigt
      Set F_pt
      Reset M_sa.0                               'LED gn: Aus
      If T_blk = 0 Then
         T_blk = 30
         M_sa.1 = Not M_sa.1                     'LED rt: E/A
      End If
      Set M_sa.2                                 'Transistor: Ein
   Else
      If F_pt = 1 Then                           'Prftaste nicht bettigt
         Reset F_pt
         Reset M_sa.2                            'Transistor: Aus
      End If
   End If

'Betriebsart
'-Die gewhlte Betriebsart hat keinen Einflu bei aktiven Prfbetrieb!
   If F_pt = 1 Then Goto M_ausgabe               '-> Ausgnge schalten

Select Case M_ba
'Schalten laut Boolscher Funktion
   Case 0
      If F_m_aes = 0 Then
         Set M_sa.2                              'Transistor: Ein
      Else
         Reset M_sa.2                            'Transistor: Aus
      End If

'Schalten im Flip-Flop Betrieb
   Case 1
      If F_ein = 0 And F_m_aes = 0 Then
         Set F_ein
         Set M_sa.2
         Gosub Up_led_rt
         Gosub Up_war                            'Warten, bis Wechsel am Eingang
         Gosub Up_ausgang
         Goto C1_01
      End If

      If F_ein = 1 And F_m_aes = 0 Then
         Reset F_ein
         Reset M_sa.2
         Gosub Up_led_gn
         Gosub Up_war                            'Warten, bis Wechsel am Eingang
         Gosub Up_ausgang
      End If
C1_01:

'Schalten laut Boolescher Funktion mit Verzgerungszeiten
   Case 2
      If F_m_aes = 0 Then
         Reset F_aus
         If F_ein = 0 Then
            Set F_ein
            Gosub Takt_reset
            T_ein = M_ein
         End If
         If T_ein = 0 Then
            Set M_sa.2                           'Transistor: Ein
         End If
      End If

      If F_m_aes = 1 Then
         Reset F_ein
         If F_aus = 0 Then
            Set F_aus
            Gosub Takt_reset
            T_aus = M_aus
         End If
         If T_aus = 0 Then
            Reset M_sa.2                         'Transistor: Aus
         End If
      End If

'Taktgeber (Betrieb laut Boolescher Funktion)
   Case 3
      If F_ein = 0 And F_m_aes = 0 Then
         Set F_ein
         T_ein = M_ein
         T_aus = M_ein + M_aus
         Gosub Takt_reset
      End If

      If F_ein = 1 And T_aus > 0 Then
         If T_ein > 0 Then
            Set M_sa.2                           'Transistor: Ein
         Else
            Reset M_sa.2                         'Transistor: Aus
         End If
      Else
         Reset F_ein
      End If

      If F_m_aes = 1 Then                        'Ausschalten Blinker
         Reset F_ein
         Reset M_sa.2                            'Transistor: Aus
      End If
End Select

'Steuerung der Ausgabe
'-Farbe der LED initialisieren (nicht im Prfbetrieb)
   If M_sa.2 = 1 Then
      Gosub Up_led_rt
   Else
      Gosub Up_led_gn
         If F_e12 = 0 And M_ba <> 3 Then Gosub Up_led_ge
   End If

'-Ausgnge schalten
M_ausgabe:
   Gosub Up_ausgang
Loop
End                                              'Programmende

'-------------------------------------------------------------------------------
'=== U N T E R P R O G R A M M =================================================
'-------------------------------------------------------------------------------
'%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
'Logikbedingung initialisieren
'-Definition der Speicherbelegung
' 0000_00xx
'        ||___ E1 bzw. M_aes.1
'        |____ E2 bzw. M_aes.2

'-Warten
Up_war:
   M_fkt.0 = E1 : M_fkt.1 = E2                   'Auswertung: Eingnge
   Select Case M_fkt
'-[03 Funktionsbedingung]
'--Funktion bentigt eine "Case"-Anweisung
      Case 0                                     '[FKT1-AND]
'      Case 1 To 3                                '[FKT2-NAND]
'      Case 0 To 2                                '[FKT3-OR]
'      Case 3                                     '[FKT4-NOR]
'      Case 1 To 2                                '[FKT5-XOR]
'      Case 2                                     '[FKT7-Inhibition]
         Goto Up_war
'- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
'--Funktion bentigt zwei "Case"-Anweisungen
'      Case 0                                     '[FKT6-XNOR]
'      Case 0 To 1                                '[FKT8-Implikation]
'         Goto Up_war
'      Case 3                                     '[FKT6-XNOR]
'      Case 3                                     '[FKT8-Implikation]
'         Goto Up_war
   End Select
Return
'%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

'Entprellen
Up_epr:
   T_epr = 0
Epr_01:
   If T_epr <= M_epr Then                        'Entprellen
      Goto Epr_01                                ' => Zeit-Schleife
   End If
Return

'Ausgnge steuern
Up_ausgang:
   A_led_gn = M_sa.0                             'Ausgang: LED gn
   A_led_rt = M_sa.1                             'Ausgang: LED rt
   A_transistor = M_sa.2                         'Ausgang: Schalttransistor
Return

'Steuerung
'-LED gn
Up_led_gn:
   M_sa.0 = 1                                    'LED gn: Ein
   M_sa.1 = 0                                    'LED rt: Aus
Return

'-LED ge
Up_led_ge:
   M_sa.0 = 1                                    'LED gn: Ein
   M_sa.1 = 1                                    'LED rt: Aus
Return

'-LED rt
Up_led_rt:
   M_sa.0 = 0                                    'LED gn: Ein
   M_sa.1 = 1                                    'LED rt: Aus
Return

'Zhler der Taktzeiten auf Null setzen (bei Zhlbeginn der Verzgerungszeit)
Takt_reset:
   Timer1 = Ta_ve
   Ta_001ms = 0
   Ta_010ms = 0
   Ta_100ms = 0
Return

'Zeittakt (Taktgeber, Ein- bzw. Ausschaltverzgerungen)
' Der Zeittakt wird durch das Flag "Zeitbasis" (F_zb) festgelegt
Takt:
   If T_ein > 0 Then Decr T_ein                  'Einschaltverzgerung [s]
   If T_aus > 0 Then Decr T_aus                  'Ausschaltverzgerung [s]
Return

'-------------------------------------------------------------------------------
'=== I N T E R R U P T R O U T I N E ===========================================
'-------------------------------------------------------------------------------
Int_t1:
'Interrupt wird durch berlauf (65.536) von Timer1 ausgelst
' Voreinstellwert 65.036 ergibt Impulse von 1 ms Lnge
'Takterzeugung [ms]
   Timer1 = Ta_ve                                'Voreinstellung fr berlauf
   Incr Ta_001ms                                 'Zhlung: Systemtakt
   Incr T_epr                                    'Zhlung: Entprellzeit

' Zeitauswertung
   If Ta_001ms = 10 Then
      Ta_001ms = 0 : Incr Ta_010ms
      If T_blk > 0 Then Decr T_blk               'Blinkzeit [10 ms]
      If Ta_010ms = 10 Then
         Ta_010ms = 0 : Incr Ta_100ms
'Zeiten der Ein- und Ausschaltverzgerung verringern
            If F_zb = 0 Then                     'Zeitbasis 100 ms
               Gosub Takt
            End If
         If Ta_100ms = 10 Then
            Ta_100ms = 0
'Zeiten der Ein- und Ausschaltverzgerung verringern
            If F_zb = 1 Then                     'Zeitbasis 1000 ms
               Gosub Takt
            End If
         End If
      End If
   End If
Return

'Ende des Quellcodes